#ifndef __DM_USB_DEVICE_H__
#define __DM_USB_DEVICE_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

////////////////////////////////////////////////////////////////////////////////

//Define the 2 possible modes of operation
#define CLIENT_HID_MODE                 0
#define CLIENT_CRESTRON_CONSOLE_MODE    1
#define CLIENT_CRESTRON_TP_DGE2_MODE    2
#define USB_DEVICE_IO_PROC_MODE         3
#define USB_DEVICE_IO_PROC_2_MODE       4
#define USB_DEVICE_IO_PROC_3_MODE       5


//typedef INT32 (*ECONNFUNC)(UINT32 param, UINT32 remoteIp, UINT16 remotePort);
//typedef INT32 (*EDATAFUNC)(UINT32 param, UINT8 * pData, UINT32 dataBytes);
typedef struct
{
  UINT8  bEventId; // which event to signal
  UINT8  bData;    // event specific data
  UINT16 sData;
  UINT32 lData2;   // event specific data
}NetPacketRxEvent;

typedef enum
{
    ERR_USBD_EP_IN_INIT = 0,        // 00  Error initializing in endpoint (data to host)
    ERR_USBD_EP_OUT_INIT,           // 01  Console initialization failed
    ERR_USBD_EP_SEND,               // 02  IN function send failure
    ERR_USBD_EP_RECEIVE,            // 03  OUT function receive failure
    ERR_USBD_EP_MEMORY,             // 04  OUT function memory allocation failed
    ERR_USBD_EP_PTR,                // 05  Interface pointer for the endpoint is not initialized
    ERR_USBD_ERR_MAPPER_PKT,        // 06  Invalid packet on the mapper
} ERROR_USB_DEVICE;
////////////////////////////////////////////////////////////////////////////////

// define in processor specific file:
extern UINT8 g_HostDetected;
//extern UINT8 USB_Host_Connected;

extern void USBControlerInit(UINT32 mode);

extern void USBConsoleInit(void);

extern INT32 USBConsoleRxData(UINT32 param, UINT8 * pData, UINT32 dataBytes);
extern void USBConsoleDisplayWelcomeMessage(void);
extern void USBConsoleTx(UINT8 * pSrc, UINT32 byteCnt, UINT32 inst);
extern void USBConsoleCloseInput( void );

extern BOOL USBGetHostConnectionStatus(void);

#define USB_Host_Connected  USBGetHostConnectionStatus()

extern void USBDevicePresent(void);
extern void USBDeviceAbsent(void);

extern void (*pGenericEpInt[9])(void);

void USB_Monitor(void);

extern int HIDEmulateMessage(char * pData, int length);
extern char* HIDGetEmulatedMessageFeedback(void);

extern INT32 USBUpgrade(UINT32 argc, char * cmd);

extern void USBHIDParseGIOMessage(UINT8* packet);
extern void USBHIDDigitalCommand( UINT32 join, UINT32 value );
extern void USBHIDAnalogCommand( UINT32 join, UINT32 value );

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif  //__DM_USB_DEVICE_H__

